/************************************************************************
 * @file: AudioFaderTest.cpp
 *
 * @description: This header file includes internal structs, functions
 * that register and unregister with GDA, a function that will create
 * Gstreamer pipeline.
 *
 * @authors: Athreya Manasa Balaraj, ManasaBalaraj.Athreya@in.bosch.com 2017
 *           Devi Laxmi, Laxmi.Devi@in.bosch.com 2017
 *
 * copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#ifndef __gst_test_application_H__
#define __gst_test_application_H__

/*! @file gst_player.h
 *  Gstreamer Application Entities.
 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdlib.h>
#include <stdio.h>
#include "gst_dlt_adapter.h"

/** @brief Macro for number of pipelines */
#define PLAYER_INSTANCE_CNT 2

/** @brief Macro for DLT Injection service ID */
#define DLT_SERVICEID 0x2000

typedef struct player_info {
    uint32_t        player_inst; /* player instance*/
    GDA_CTX         gda_ctx;     /* GDA_CTX for that player instance*/
    char*           filename;
}player_info_t;

typedef struct sync_handler_data
{
    GMainLoop       *loop;                      /* GMainLoop instance */
    char            dlt_contextID[DLT_ID_SIZE]; /* DLT context ID */
}sync_handler_data_t;

/** @brief Registers with GDA.
 *  @param player_info  The player instance and corresponding GDA_CTX to be registered.
 */
GDA_ER gst_initialize (player_info_t * player_info);

/** @brief This module will create Gstreamer pipeline based on threads
  * which call this function.
  * @param data Pointer to struct with the player_inst and its corresponding GDA_CTX.
  */
void* gst_create_pipeline_thread (void * data);

/** @brief Unregisters with GDA.
 *  @param gda_ctx  The GDA_CTX to be unregistered.
 */
GDA_ER gst_finalize (GDA_CTX * gda_ctx);

#ifdef __cplusplus
}
#endif

#endif
